/* SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB */
/* Copyright (c) 2015 - 2020 Intel Corporation */
#ifndef IRDMA_VIRTCHNL_H
#define IRDMA_VIRTCHNL_H

#include "hmc.h"

#pragma pack(push, 1)

struct irdma_virtchnl_op_buf {
	u16 iw_op_code;
	u16 iw_op_ver;
	u16 iw_chnl_buf_len;
	u16 rsvd;
	u64 iw_chnl_op_ctx;
	/* Member alignment MUST be maintained above this location */
	u8 iw_chnl_buf[1];
};

struct irdma_virtchnl_resp_buf {
	u64 iw_chnl_op_ctx;
	u16 iw_chnl_buf_len;
	s16 iw_op_ret_code;
	/* Member alignment MUST be maintained above this location */
	u16 rsvd[2];
	u8 iw_chnl_buf[1];
};

enum irdma_virtchnl_ops {
	IRDMA_VCHNL_OP_GET_VER = 0,
	IRDMA_VCHNL_OP_GET_HMC_FCN = 1,
	IRDMA_VCHNL_OP_PUT_HMC_FCN = 2,
	IRDMA_VCHNL_OP_ADD_HMC_OBJ_RANGE = 3,
	IRDMA_VCHNL_OP_DEL_HMC_OBJ_RANGE = 4,
	IRDMA_VCHNL_OP_GET_STATS = 5,
	IRDMA_VCHNL_OP_MANAGE_STATS_INST = 6,
	IRDMA_VCHNL_OP_MCG = 7,
	IRDMA_VCHNL_OP_UP_MAP = 8,
	IRDMA_VCHNL_OP_MANAGE_WS_NODE = 9,
};

#define IRDMA_VCHNL_CHNL_VER_V0 0
#define IRDMA_VCHNL_CHNL_VER_V1 1

#define IRDMA_VCHNL_OP_GET_VER_V0 0
#define IRDMA_VCHNL_OP_GET_VER_V1 1

#define IRDMA_VCHNL_OP_GET_HMC_FCN_V0 0
#define IRDMA_VCHNL_OP_PUT_HMC_FCN_V0 0
#define IRDMA_VCHNL_OP_ADD_HMC_OBJ_RANGE_V0 0
#define IRDMA_VCHNL_OP_DEL_HMC_OBJ_RANGE_V0 0
#define IRDMA_VCHNL_OP_GET_STATS_V0 0
#define IRDMA_VCHNL_OP_MANAGE_WS_NODE_V0 0

struct irdma_dev_hw_stats;

struct irdma_virtchnl_hmc_obj_range {
	u16 obj_type;
	u16 rsvd;
	u32 start_index;
	u32 obj_count;
};

struct irdma_virtchnl_manage_ws_node {
	u8 add;
	u8 user_pri;
};

enum irdma_status_code irdma_vchnl_recv_pf(struct irdma_sc_dev *dev,
					   u32 vf_id,
					   u8 *msg,
					   u16 len);

enum irdma_status_code irdma_vchnl_recv_vf(struct irdma_sc_dev *dev,
					   u32 vf_id,
					   u8 *msg,
					   u16 len);

struct irdma_virtchnl_req {
	struct irdma_sc_dev *dev;
	struct irdma_virtchnl_op_buf *vchnl_msg;
	void *parm;
	u32 vf_id;
	u16 parm_len;
	u16 resp_len;
	s16 ret_code;
};

#pragma pack(pop)

#endif
