/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge;

import com.microsoft.datatransfer.bridge.orc.ColumnPropertiesBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class OrcValidator {
    private static final double EPSILON = 1.0E-5;
    private static final String[] SerdeTypeNames;

    private static boolean equalNative(Object src, String dst) {
        if (src == null) {
            return StringUtils.isEmpty((String)dst);
        }
        if (src instanceof Number) {
            if (dst.contains(".")) {
                return Math.abs(((Number)src).doubleValue() - Double.parseDouble(dst)) < 1.0E-5;
            }
            return ((Number)src).longValue() == Long.parseLong(dst);
        }
        if (src instanceof Boolean) {
            return src.equals(Boolean.parseBoolean(dst));
        }
        if (src instanceof String) {
            return src.equals(dst);
        }
        if (src instanceof HiveDecimal) {
            return ((HiveDecimal)src).bigDecimalValue().compareTo(new BigDecimal(dst)) == 0;
        }
        if (src instanceof byte[]) {
            return Arrays.equals((byte[])src, Base64.decodeBase64((String)dst));
        }
        if (src instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            try {
                int pointIndex = dst.indexOf(46);
                if (dst.length() - pointIndex > 4) {
                    dst = dst.substring(0, pointIndex + 4);
                }
                return ((Date)src).getTime() == format.parse(dst).getTime();
            }
            catch (ParseException e) {
                return false;
            }
        }
        return false;
    }

    public static String[] readCsvLine(BufferedReader is) {
        try {
            String line = is.readLine();
            if (line == null) {
                return new String[0];
            }
            String[] rowCells = line.split(",", -1);
            String[] trimmed = new String[rowCells.length];
            for (int i = 0; i < rowCells.length; ++i) {
                trimmed[i] = rowCells[i].trim();
            }
            return trimmed;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateWithCsvExpect(String orcPath, String csvPath) throws IllegalArgumentException, IOException, SecurityException, IllegalAccessException, InvocationTargetException {
        BufferedReader csvReader = null;
        RecordReader rr = null;
        try {
            csvReader = new BufferedReader(new FileReader(csvPath));
            Configuration conf = new Configuration();
            Reader reader = OrcFile.createReader((Path)new Path(orcPath), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf).filesystem((FileSystem)FileSystem.getLocal((Configuration)conf)));
            rr = reader.rows();
            StructObjectInspector inspector = (StructObjectInspector)reader.getObjectInspector();
            List fields = inspector.getAllStructFieldRefs();
            while (rr.hasNext()) {
                OrcStruct row = (OrcStruct)rr.next(null);
                List rowData = inspector.getStructFieldsDataAsList((Object)row);
                String[] expectValues = OrcValidator.readCsvLine(csvReader);
                if (expectValues.length != rowData.size()) {
                    boolean bl = false;
                    return bl;
                }
                for (int i = 0; i < rowData.size(); ++i) {
                    PrimitiveObjectInspector fieldObjectInspector = (PrimitiveObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector();
                    if (OrcValidator.equalNative(fieldObjectInspector.getPrimitiveJavaObject(rowData.get(i)), expectValues[i])) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = OrcValidator.readCsvLine(csvReader).length == 0;
            return bl;
        }
        finally {
            if (rr != null) {
                rr.close();
            }
            if (csvReader != null) {
                csvReader.close();
            }
        }
    }

    private static Writable String2Writable(String val, PrimitiveObjectInspector.PrimitiveCategory primeType) {
        switch (primeType) {
            case LONG: {
                return new LongWritable(Long.parseLong(val));
            }
            case INT: {
                return new IntWritable(Integer.parseInt(val));
            }
            case SHORT: {
                return new ShortWritable(Short.parseShort(val));
            }
            case BYTE: {
                return new ByteWritable(Byte.parseByte(val));
            }
            case DOUBLE: {
                return new DoubleWritable(Double.parseDouble(val));
            }
            case FLOAT: {
                return new FloatWritable(Float.parseFloat(val));
            }
            case STRING: {
                return new Text(val);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void csv2Orc(String csvPath, String orcPath, ByteBuffer typeBuf) throws SerDeException, IOException {
        BufferedReader br = null;
        Writer writer = null;
        try {
            Configuration conf = new Configuration();
            OrcFile.WriterOptions opts = OrcFile.writerOptions((Configuration)conf);
            opts.fileSystem((FileSystem)FileSystem.getLocal((Configuration)conf));
            OrcSerde serde = new OrcSerde();
            ColumnPropertiesBuilder builder = new ColumnPropertiesBuilder();
            while (typeBuf.hasRemaining()) {
                byte ordinal = typeBuf.get();
                builder.column(SerdeTypeNames[ordinal]);
            }
            serde.initialize(conf, builder.build());
            opts.inspector(serde.getObjectInspector());
            SettableStructObjectInspector rowSetter = (SettableStructObjectInspector)serde.getObjectInspector();
            OrcStruct row = (OrcStruct)rowSetter.create();
            Object[] allField = rowSetter.getAllStructFieldRefs().toArray();
            File orcFile = new File(orcPath);
            if (orcFile.exists()) {
                orcFile.delete();
            }
            writer = OrcFile.createWriter((Path)new Path(orcPath), (OrcFile.WriterOptions)opts);
            br = new BufferedReader(new FileReader(csvPath));
            String[] lines = OrcValidator.readCsvLine(br);
            while (lines.length > 0) {
                for (int i = 0; i < lines.length; ++i) {
                    StructField field = (StructField)allField[i];
                    PrimitiveObjectInspector fieldInspector = (PrimitiveObjectInspector)field.getFieldObjectInspector();
                    rowSetter.setStructFieldData((Object)row, field, (Object)OrcValidator.String2Writable(lines[i], fieldInspector.getPrimitiveCategory()));
                }
                writer.addRow((Object)row);
                lines = OrcValidator.readCsvLine(br);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    static {
        PrimitiveObjectInspector.PrimitiveCategory[] values;
        SerdeTypeNames = new String[PrimitiveObjectInspector.PrimitiveCategory.values().length];
        for (PrimitiveObjectInspector.PrimitiveCategory cat : values = PrimitiveObjectInspector.PrimitiveCategory.values()) {
            OrcValidator.SerdeTypeNames[cat.ordinal()] = cat.name().toLowerCase();
        }
        OrcValidator.SerdeTypeNames[PrimitiveObjectInspector.PrimitiveCategory.LONG.ordinal()] = "bigint";
        OrcValidator.SerdeTypeNames[PrimitiveObjectInspector.PrimitiveCategory.SHORT.ordinal()] = "smallint";
        OrcValidator.SerdeTypeNames[PrimitiveObjectInspector.PrimitiveCategory.BYTE.ordinal()] = "tinyint";
    }
}

