/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge.io;

import com.microsoft.datatransfer.bridge.io.IoBridge;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;

public class BridgeInputStream
extends InputStream
implements PositionedReadable,
Seekable {
    public static final int DEFAULT_READ_BUFFER_SIZE = 0x400000;
    private long dotnetHandle;
    private ByteBuffer readBuffer;

    public BridgeInputStream(long rawStreamHandle) throws IOException {
        this.dotnetHandle = IoBridge.inputStreamCreate(rawStreamHandle);
        if (this.dotnetHandle == 0L) {
            throw new IOException("Cannot open .net resource");
        }
        this.readBuffer = ByteBuffer.allocateDirect(0x400000);
        this.readBuffer.limit(0);
    }

    public int read() throws IOException {
        if (!this.readBuffer.hasRemaining() && !this.fillBuffer()) {
            return -1;
        }
        return this.readBuffer.get() & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int nRead = 0;
        while (len > 0) {
            if (!this.readBuffer.hasRemaining() && !this.fillBuffer()) {
                return nRead;
            }
            int readLen = Math.min(len, this.readBuffer.remaining());
            this.readBuffer.get(b, off, readLen);
            off += readLen;
            len -= readLen;
            nRead += readLen;
        }
        return nRead;
    }

    public void close() throws IOException {
        if (this.dotnetHandle == 0L) {
            return;
        }
        try {
            IoBridge.inputStreamClose(this.dotnetHandle);
        }
        finally {
            IoBridge.inputStreamDestroy(this.dotnetHandle);
            this.dotnetHandle = 0L;
        }
    }

    public long skip(long n) throws IOException {
        if (this.dotnetHandle == 0L) {
            throw new IOException("Stream is closed.");
        }
        int rem = this.readBuffer.remaining();
        if (n <= (long)rem) {
            this.readBuffer.position(this.readBuffer.position() + (int)n);
            return n;
        }
        this.readBuffer.position(0);
        this.readBuffer.limit(0);
        return IoBridge.inputStreamSkip(this.dotnetHandle, n - (long)rem);
    }

    private boolean fillBuffer() throws IOException {
        if (this.dotnetHandle == 0L) {
            throw new IOException("Stream is closed.");
        }
        this.readBuffer.clear();
        IoBridge.inputStreamRead(this.dotnetHandle, this.readBuffer);
        this.readBuffer.flip();
        return this.readBuffer.limit() > 0;
    }

    protected void finalize() throws Throwable {
        IoBridge.inputStreamDestroy(this.dotnetHandle);
        super.finalize();
    }

    public long getPos() throws IOException {
        return IoBridge.inputStreamPosition(this.dotnetHandle);
    }

    public void seek(long n) throws IOException {
        if (this.dotnetHandle == 0L) {
            throw new IOException("Stream is closed.");
        }
        this.readBuffer.position(0);
        this.readBuffer.limit(0);
        IoBridge.inputStreamSeek(this.dotnetHandle, n);
    }

    public boolean seekToNewSource(long arg0) throws IOException {
        return false;
    }

    public int read(long position, byte[] buf, int off, int len) throws IOException {
        this.seek(position);
        return this.read(buf, off, len);
    }

    public void readFully(long position, byte[] buf) throws IOException {
        this.seek(position);
        this.read(buf, 0, buf.length);
    }

    public void readFully(long position, byte[] buf, int off, int len) throws IOException {
        this.seek(position);
        this.read(buf, off, len);
    }
}

