/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge.orc;

import com.microsoft.datatransfer.bridge.orc.OrcBridge;
import com.microsoft.datatransfer.bridge.orc.OrcValueHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;

public class OrcMapBridge
implements OrcBridge {
    protected MapObjectInspector inspector;
    protected Object value;
    protected Map<Object, Object> content;

    public OrcMapBridge(Object value, MapObjectInspector inspector) {
        this.inspector = inspector;
        this.value = value;
        HashMap<Object, Object> keyvalues = new HashMap<Object, Object>();
        Map values = this.inspector.getMap(value);
        for (Object key : values.keySet()) {
            Object val = values.get(key);
            keyvalues.put(OrcValueHelper.createValue(inspector.getMapKeyObjectInspector(), key), OrcValueHelper.createValue(inspector.getMapValueObjectInspector(), val));
        }
    }

    public Object[] keys() {
        return this.content.keySet().toArray();
    }

    public Object get(Object key) {
        return this.content.get(key);
    }

    public int getKeyPrimitiveTypeCode() {
        return OrcValueHelper.getPrimitiveTypeCode(this.inspector.getMapKeyObjectInspector());
    }

    public int getValueTypeCode() {
        return OrcValueHelper.getTypeCode(this.inspector.getMapValueObjectInspector());
    }

    public int getValuePrimitiveTypeCode() {
        return OrcValueHelper.getPrimitiveTypeCode(this.inspector.getMapValueObjectInspector());
    }

    public Object getNativeObject() {
        return this.value;
    }
}

