/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge.orc;

import com.microsoft.datatransfer.bridge.orc.OrcBridge;
import com.microsoft.datatransfer.bridge.orc.OrcValueHelper;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class OrcStructBridge
implements OrcBridge {
    protected Object struct;
    protected StructObjectInspector inspector;

    public OrcStructBridge(Object struct, StructObjectInspector inspector) {
        this.struct = struct;
        this.inspector = inspector;
    }

    public Object[] getAllValues() {
        return this.inspector.getStructFieldsDataAsList(this.struct).toArray();
    }

    public Object[] getAllFieldInfo() {
        return this.inspector.getAllStructFieldRefs().toArray();
    }

    public StructField getFieldInfo(String name) {
        return this.inspector.getStructFieldRef(name);
    }

    public String getFieldName(StructField field) {
        return field.getFieldName();
    }

    public Object getValue(StructField field) {
        Object val = this.inspector.getStructFieldData(this.struct, field);
        return OrcValueHelper.createValue(field.getFieldObjectInspector(), val);
    }

    public int getPrimitiveTypeCode(StructField field) {
        return OrcValueHelper.getPrimitiveTypeCode(field.getFieldObjectInspector());
    }

    public int getTypeCode(StructField field) {
        return OrcValueHelper.getTypeCode(field.getFieldObjectInspector());
    }

    public Object getNativeObject() {
        return this.struct;
    }
}

