/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge.orc;

import com.microsoft.datatransfer.bridge.orc.OrcListBridge;
import com.microsoft.datatransfer.bridge.orc.OrcMapBridge;
import com.microsoft.datatransfer.bridge.orc.OrcStructBridge;
import com.microsoft.datatransfer.bridge.orc.OrcUnionBridge;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;

public class OrcValueHelper {
    public static Object createValue(ObjectInspector inspector, Object value) {
        ObjectInspector.Category cat = inspector.getCategory();
        switch (cat) {
            case PRIMITIVE: {
                return ((PrimitiveObjectInspector)inspector).getPrimitiveJavaObject(value);
            }
            case STRUCT: {
                return new OrcStructBridge(value, (StructObjectInspector)inspector);
            }
            case MAP: {
                return new OrcMapBridge(value, (MapObjectInspector)inspector);
            }
            case LIST: {
                return new OrcListBridge(value, (ListObjectInspector)inspector);
            }
            case UNION: {
                return new OrcUnionBridge(value, (UnionObjectInspector)inspector);
            }
        }
        return null;
    }

    public static int getTypeCode(ObjectInspector inspector) {
        return inspector.getCategory().ordinal();
    }

    public static int getPrimitiveTypeCode(ObjectInspector inspector) {
        return ((PrimitiveObjectInspector)inspector).getPrimitiveCategory().ordinal();
    }
}

