/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge.orc;

import com.microsoft.datatransfer.bridge.io.BridgeFileSystem;
import com.microsoft.datatransfer.bridge.orc.OrcBatchWriter;
import com.microsoft.datatransfer.bridge.orc.OrcBridge;
import com.microsoft.datatransfer.bridge.orc.OrcMutableStructBridge;
import com.microsoft.datatransfer.bridge.orc.WriterOptionBridge;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;

public class OrcWriterBridge {
    private Writer writer;
    private ObjectInspector rootInspector;

    public static OrcWriterBridge open(long rawStreamHandle, WriterOptionBridge opts) throws SerDeException, IOException {
        OrcFile.WriterOptions nativeOpts = opts.getOptions();
        nativeOpts.fileSystem((FileSystem)new BridgeFileSystem(rawStreamHandle, 0L));
        return new OrcWriterBridge(OrcFile.createWriter((Path)new Path(String.valueOf(rawStreamHandle)), (OrcFile.WriterOptions)nativeOpts), opts.getInspector());
    }

    OrcWriterBridge(Writer writer, ObjectInspector rootInspector) {
        this.writer = writer;
        this.rootInspector = rootInspector;
    }

    public void addRow(OrcBridge row) throws IOException {
        this.writer.addRow(row.getNativeObject());
    }

    public void addUserMetadata(String key, ByteBuffer content) {
        this.writer.addUserMetadata(key, content);
    }

    public OrcMutableStructBridge createRootStruct() {
        return new OrcMutableStructBridge((SettableStructObjectInspector)this.rootInspector);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public OrcBatchWriter createBatchWriter() throws InvalidOperationException {
        return new OrcBatchWriter(this.writer, (SettableStructObjectInspector)this.rootInspector);
    }
}

